/* parser generated by jison 0.4.17 */
/*
  Returns a Parser object of the following structure:

  Parser: {
    yy: {}
  }

  Parser.prototype: {
    yy: {},
    trace: function(),
    symbols_: {associative list: name ==> number},
    terminals_: {associative list: number ==> name},
    productions_: [...],
    performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
    table: [...],
    defaultActions: {...},
    parseError: function(str, hash),
    parse: function(input),

    lexer: {
        EOF: 1,
        parseError: function(str, hash),
        setInput: function(input),
        input: function(),
        unput: function(str),
        more: function(),
        less: function(n),
        pastInput: function(),
        upcomingInput: function(),
        showPosition: function(),
        test_match: function(regex_match_array, rule_index),
        next: function(),
        lex: function(),
        begin: function(condition),
        popState: function(),
        _currentRules: function(),
        topState: function(),
        pushState: function(condition),

        options: {
            ranges: boolean           (optional: true ==> token location info will include a .range[] member)
            flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
            backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
        },

        performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
        rules: [...],
        conditions: {associative list: name ==> set},
    }
  }


  token location info (@$, _$, etc.): {
    first_line: n,
    last_line: n,
    first_column: n,
    last_column: n,
    range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
  }


  the parseError function receives a 'hash' object with these members for lexer and parser errors: {
    text:        (matched text)
    token:       (the produced terminal token, if any)
    line:        (yylineno)
  }
  while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
    loc:         (yylloc)
    expected:    (string describing the set of expected tokens)
    recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
  }
*/
var MathParser = (function(){
var o=function(k,v,o,l){for(o=o||{},l=k.length;l--;o[k[l]]=v);return o},$V0=[1,3],$V1=[1,4],$V2=[1,8],$V3=[1,9],$V4=[1,11],$V5=[1,12],$V6=[1,13],$V7=[1,14],$V8=[1,17],$V9=[1,16],$Va=[1,18],$Vb=[1,19],$Vc=[5,6,8,10,11,21],$Vd=[5,6,8,21];
var parser = {trace: function trace() { },
yy: {},
symbols_: {"error":2,"expr":3,"OPEN_PAREN":4,"CLOSE_PAREN":5,"MINUS":6,"add_op":7,"PLUS":8,"mult_op":9,"TIMES":10,"DIVIDED_BY":11,"value":12,"NUMBER":13,"STRING":14,"xpath_op":15,"VALUE_XPATH":16,"LENGTH_XPATH":17,"SUM_XPATH":18,"SLICE_XPATH":19,"expression":20,"END":21,"$accept":0,"$end":1},
terminals_: {2:"error",4:"OPEN_PAREN",5:"CLOSE_PAREN",6:"MINUS",8:"PLUS",10:"TIMES",11:"DIVIDED_BY",13:"NUMBER",14:"STRING",16:"VALUE_XPATH",17:"LENGTH_XPATH",18:"SUM_XPATH",19:"SLICE_XPATH",21:"END"},
productions_: [0,[3,3],[3,2],[3,1],[7,3],[7,3],[7,1],[9,3],[9,3],[9,1],[12,1],[12,1],[12,1],[15,1],[15,1],[15,1],[15,1],[20,2]],
performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
/* this == yyval */

var $0 = $$.length - 1;
switch (yystate) {
case 1:
 this.$ = $$[$0-1]; 
break;
case 2:
 this.$ = {op:'negate',value:$$[$0]}; 
break;
case 3: case 6: case 9: case 12:
 this.$ = $$[$0]; 
break;
case 4:
 this.$ = {op:'add',left:$$[$0-2],right:$$[$0]}; 
break;
case 5:
 this.$ = {op:'subtract',left:$$[$0-2],right:$$[$0]}; 
break;
case 7:
 this.$ = {op:'multiply',left:$$[$0-2],right:$$[$0]}; 
break;
case 8:
 this.$ = {op:'divide',left:$$[$0-2],right:$$[$0]}; 
break;
case 10:
 this.$ = {op:'literal',value:parseFloat(yytext)}; 
break;
case 11:
 this.$ = {op:'literal',value:yytext.slice(1,-1)}; 
break;
case 13:
 this.$ = {op:'xpath',value:yytext.slice(2,-1)}; 
break;
case 14:
 this.$ = {op:'lengthof',value:{op:'xpath',value:yytext.slice(2,-1)}}; 
break;
case 15:
 this.$ = {op:'sum',value:{op:'xpath',value:yytext.slice(2,-1)}}; 
break;
case 16:

										var data = yytext.slice(2,-1);
										data = data.split('|');
										this.$ = {op:'slice',value:{op:'xpath',value:data[0]}};
										data = data[1].split(',');
										if(isNaN(this.$.start = parseInt(data[0])))
											this.$.start = undefined;
										if(isNaN(this.$.end = parseInt(data[1])))
											this.$.end = undefined;
									
break;
case 17:


		var ret = {
			xpaths: {}
		};

		function findXPaths(obj){
			if(!obj){
				return null;
			}
			else if(obj.op === 'xpath'){
				ret.xpaths[obj.value] = null;
			}
			else if(obj.left && obj.right){
				findXPaths(obj.left);
				findXPaths(obj.right);
			}
			else {
				findXPaths(obj.value);
			}
		}

		findXPaths($$[$0-1]);

		ret.evaluate = function(){
			return (function evaluate(parse)
			{
				if(!parse)
					return null;
				
				else if(parse.op === 'literal')
					return parse.value;
				
				else if(parse.op === 'xpath'){
					if(ret.xpaths[parse.value] === null){
						throw 'No value for xpath '+parse.value;
					}
					else return ret.xpaths[parse.value];
				}

				else if(parse.op === 'add')
					return evaluate(parse.left) + evaluate(parse.right);
				
				else if(parse.op === 'subtract')
					return evaluate(parse.left) - evaluate(parse.right);

				else if(parse.op === 'multiply')
					return evaluate(parse.left) * evaluate(parse.right);

				else if(parse.op === 'divide')
					return evaluate(parse.left) / evaluate(parse.right);

				else if(parse.op === 'negate')
					return -evaluate(parse.value);

				else if(parse.op === 'sum'){
					var val = evaluate(parse.value);
					if(val.reduce)
						return evaluate(parse.value).reduce(function(sum,val){return sum+val;},0);
					else
						return null;
				}

				else if(parse.op === 'lengthof')
					return evaluate(parse.value).length || null;

				else if(parse.op === 'slice'){
					var val = evaluate(parse.value);
					if(val.slice)
						return val.slice(parse.start,parse.end);
					else
						return null;
				}

				else
					throw 'Unknown operation: '+parse.op;
			})($$[$0-1]);
		};

		return ret;
	
break;
}
},
table: [{3:2,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7,20:1},{1:[3]},{6:$V8,8:$V9,10:$Va,11:$Vb,21:[1,15]},{3:20,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},{3:21,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},o($Vc,[2,3]),o($Vc,[2,6]),o($Vc,[2,9]),o($Vc,[2,10]),o($Vc,[2,11]),o($Vc,[2,12]),o($Vc,[2,13]),o($Vc,[2,14]),o($Vc,[2,15]),o($Vc,[2,16]),{1:[2,17]},{3:22,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},{3:23,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},{3:24,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},{3:25,4:$V0,6:$V1,7:5,9:6,12:7,13:$V2,14:$V3,15:10,16:$V4,17:$V5,18:$V6,19:$V7},{5:[1,26],6:$V8,8:$V9,10:$Va,11:$Vb},o($Vc,[2,2]),o($Vd,[2,4],{10:$Va,11:$Vb}),o($Vd,[2,5],{10:$Va,11:$Vb}),o($Vc,[2,7]),o($Vc,[2,8]),o($Vc,[2,1])],
defaultActions: {15:[2,17]},
parseError: function parseError(str, hash) {
    if (hash.recoverable) {
        this.trace(str);
    } else {
        function _parseError (msg, hash) {
            this.message = msg;
            this.hash = hash;
        }
        _parseError.prototype = Error;

        throw new _parseError(str, hash);
    }
},
parse: function parse(input) {
    var self = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = '', yylineno = 0, yyleng = 0, recovering = 0, TERROR = 2, EOF = 1;
    var args = lstack.slice.call(arguments, 1);
    var lexer = Object.create(this.lexer);
    var sharedState = { yy: {} };
    for (var k in this.yy) {
        if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
        }
    }
    lexer.setInput(input, sharedState.yy);
    sharedState.yy.lexer = lexer;
    sharedState.yy.parser = this;
    if (typeof lexer.yylloc == 'undefined') {
        lexer.yylloc = {};
    }
    var yyloc = lexer.yylloc;
    lstack.push(yyloc);
    var ranges = lexer.options && lexer.options.ranges;
    if (typeof sharedState.yy.parseError === 'function') {
        this.parseError = sharedState.yy.parseError;
    } else {
        this.parseError = Object.getPrototypeOf(this).parseError;
    }
    function popStack(n) {
        stack.length = stack.length - 2 * n;
        vstack.length = vstack.length - n;
        lstack.length = lstack.length - n;
    }
    _token_stack:
        var lex = function () {
            var token;
            token = lexer.lex() || EOF;
            if (typeof token !== 'number') {
                token = self.symbols_[token] || token;
            }
            return token;
        };
    var symbol, preErrorSymbol, state, action, a, r, yyval = {}, p, len, newState, expected;
    while (true) {
        state = stack[stack.length - 1];
        if (this.defaultActions[state]) {
            action = this.defaultActions[state];
        } else {
            if (symbol === null || typeof symbol == 'undefined') {
                symbol = lex();
            }
            action = table[state] && table[state][symbol];
        }
                    if (typeof action === 'undefined' || !action.length || !action[0]) {
                var errStr = '';
                expected = [];
                for (p in table[state]) {
                    if (this.terminals_[p] && p > TERROR) {
                        expected.push('\'' + this.terminals_[p] + '\'');
                    }
                }
                if (lexer.showPosition) {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ':\n' + lexer.showPosition() + '\nExpecting ' + expected.join(', ') + ', got \'' + (this.terminals_[symbol] || symbol) + '\'';
                } else {
                    errStr = 'Parse error on line ' + (yylineno + 1) + ': Unexpected ' + (symbol == EOF ? 'end of input' : '\'' + (this.terminals_[symbol] || symbol) + '\'');
                }
                this.parseError(errStr, {
                    text: lexer.match,
                    token: this.terminals_[symbol] || symbol,
                    line: lexer.yylineno,
                    loc: yyloc,
                    expected: expected
                });
            }
        if (action[0] instanceof Array && action.length > 1) {
            throw new Error('Parse Error: multiple actions possible at state: ' + state + ', token: ' + symbol);
        }
        switch (action[0]) {
        case 1:
            stack.push(symbol);
            vstack.push(lexer.yytext);
            lstack.push(lexer.yylloc);
            stack.push(action[1]);
            symbol = null;
            if (!preErrorSymbol) {
                yyleng = lexer.yyleng;
                yytext = lexer.yytext;
                yylineno = lexer.yylineno;
                yyloc = lexer.yylloc;
                if (recovering > 0) {
                    recovering--;
                }
            } else {
                symbol = preErrorSymbol;
                preErrorSymbol = null;
            }
            break;
        case 2:
            len = this.productions_[action[1]][1];
            yyval.$ = vstack[vstack.length - len];
            yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
            };
            if (ranges) {
                yyval._$.range = [
                    lstack[lstack.length - (len || 1)].range[0],
                    lstack[lstack.length - 1].range[1]
                ];
            }
            r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
            ].concat(args));
            if (typeof r !== 'undefined') {
                return r;
            }
            if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
            }
            stack.push(this.productions_[action[1]][0]);
            vstack.push(yyval.$);
            lstack.push(yyval._$);
            newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
            stack.push(newState);
            break;
        case 3:
            return true;
        }
    }
    return true;
}};
/* generated by jison-lex 0.3.4 */
var lexer = (function(){
var lexer = ({

EOF:1,

parseError:function parseError(str, hash) {
        if (this.yy.parser) {
            this.yy.parser.parseError(str, hash);
        } else {
            throw new Error(str);
        }
    },

// resets the lexer, sets new input
setInput:function (input, yy) {
        this.yy = yy || this.yy || {};
        this._input = input;
        this._more = this._backtrack = this.done = false;
        this.yylineno = this.yyleng = 0;
        this.yytext = this.matched = this.match = '';
        this.conditionStack = ['INITIAL'];
        this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
        };
        if (this.options.ranges) {
            this.yylloc.range = [0,0];
        }
        this.offset = 0;
        return this;
    },

// consumes and returns one char from the input
input:function () {
        var ch = this._input[0];
        this.yytext += ch;
        this.yyleng++;
        this.offset++;
        this.match += ch;
        this.matched += ch;
        var lines = ch.match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
        } else {
            this.yylloc.last_column++;
        }
        if (this.options.ranges) {
            this.yylloc.range[1]++;
        }

        this._input = this._input.slice(1);
        return ch;
    },

// unshifts one char (or a string) into the input
unput:function (ch) {
        var len = ch.length;
        var lines = ch.split(/(?:\r\n?|\n)/g);

        this._input = ch + this._input;
        this.yytext = this.yytext.substr(0, this.yytext.length - len);
        //this.yyleng -= len;
        this.offset -= len;
        var oldLines = this.match.split(/(?:\r\n?|\n)/g);
        this.match = this.match.substr(0, this.match.length - 1);
        this.matched = this.matched.substr(0, this.matched.length - 1);

        if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
        }
        var r = this.yylloc.range;

        this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ?
                (lines.length === oldLines.length ? this.yylloc.first_column : 0)
                 + oldLines[oldLines.length - lines.length].length - lines[0].length :
              this.yylloc.first_column - len
        };

        if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
        }
        this.yyleng = this.yytext.length;
        return this;
    },

// When called from action, caches matched text and appends it on next action
more:function () {
        this._more = true;
        return this;
    },

// When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
reject:function () {
        if (this.options.backtrack_lexer) {
            this._backtrack = true;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });

        }
        return this;
    },

// retain first n characters of the match
less:function (n) {
        this.unput(this.match.slice(n));
    },

// displays already matched input, i.e. for error messages
pastInput:function () {
        var past = this.matched.substr(0, this.matched.length - this.match.length);
        return (past.length > 20 ? '...':'') + past.substr(-20).replace(/\n/g, "");
    },

// displays upcoming input, i.e. for error messages
upcomingInput:function () {
        var next = this.match;
        if (next.length < 20) {
            next += this._input.substr(0, 20-next.length);
        }
        return (next.substr(0,20) + (next.length > 20 ? '...' : '')).replace(/\n/g, "");
    },

// displays the character position where the lexing error occurred, i.e. for error messages
showPosition:function () {
        var pre = this.pastInput();
        var c = new Array(pre.length + 1).join("-");
        return pre + this.upcomingInput() + "\n" + c + "^";
    },

// test the lexed token: return FALSE when not a match, otherwise return token
test_match:function (match, indexed_rule) {
        var token,
            lines,
            backup;

        if (this.options.backtrack_lexer) {
            // save context
            backup = {
                yylineno: this.yylineno,
                yylloc: {
                    first_line: this.yylloc.first_line,
                    last_line: this.last_line,
                    first_column: this.yylloc.first_column,
                    last_column: this.yylloc.last_column
                },
                yytext: this.yytext,
                match: this.match,
                matches: this.matches,
                matched: this.matched,
                yyleng: this.yyleng,
                offset: this.offset,
                _more: this._more,
                _input: this._input,
                yy: this.yy,
                conditionStack: this.conditionStack.slice(0),
                done: this.done
            };
            if (this.options.ranges) {
                backup.yylloc.range = this.yylloc.range.slice(0);
            }
        }

        lines = match[0].match(/(?:\r\n?|\n).*/g);
        if (lines) {
            this.yylineno += lines.length;
        }
        this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ?
                         lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length :
                         this.yylloc.last_column + match[0].length
        };
        this.yytext += match[0];
        this.match += match[0];
        this.matches = match;
        this.yyleng = this.yytext.length;
        if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
        }
        this._more = false;
        this._backtrack = false;
        this._input = this._input.slice(match[0].length);
        this.matched += match[0];
        token = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
        if (this.done && this._input) {
            this.done = false;
        }
        if (token) {
            return token;
        } else if (this._backtrack) {
            // recover context
            for (var k in backup) {
                this[k] = backup[k];
            }
            return false; // rule action called reject() implying the next rule should be tested instead.
        }
        return false;
    },

// return next match in input
next:function () {
        if (this.done) {
            return this.EOF;
        }
        if (!this._input) {
            this.done = true;
        }

        var token,
            match,
            tempMatch,
            index;
        if (!this._more) {
            this.yytext = '';
            this.match = '';
        }
        var rules = this._currentRules();
        for (var i = 0; i < rules.length; i++) {
            tempMatch = this._input.match(this.rules[rules[i]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
                match = tempMatch;
                index = i;
                if (this.options.backtrack_lexer) {
                    token = this.test_match(tempMatch, rules[i]);
                    if (token !== false) {
                        return token;
                    } else if (this._backtrack) {
                        match = false;
                        continue; // rule action called reject() implying a rule MISmatch.
                    } else {
                        // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
                        return false;
                    }
                } else if (!this.options.flex) {
                    break;
                }
            }
        }
        if (match) {
            token = this.test_match(match, rules[index]);
            if (token !== false) {
                return token;
            }
            // else: this is a lexer rule which consumes input without producing a token (e.g. whitespace)
            return false;
        }
        if (this._input === "") {
            return this.EOF;
        } else {
            return this.parseError('Lexical error on line ' + (this.yylineno + 1) + '. Unrecognized text.\n' + this.showPosition(), {
                text: "",
                token: null,
                line: this.yylineno
            });
        }
    },

// return next match that has a token
lex:function lex() {
        var r = this.next();
        if (r) {
            return r;
        } else {
            return this.lex();
        }
    },

// activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
begin:function begin(condition) {
        this.conditionStack.push(condition);
    },

// pop the previously active lexer condition state off the condition stack
popState:function popState() {
        var n = this.conditionStack.length - 1;
        if (n > 0) {
            return this.conditionStack.pop();
        } else {
            return this.conditionStack[0];
        }
    },

// produce the lexer rule set which is active for the currently active lexer condition state
_currentRules:function _currentRules() {
        if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
        } else {
            return this.conditions["INITIAL"].rules;
        }
    },

// return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
topState:function topState(n) {
        n = this.conditionStack.length - 1 - Math.abs(n || 0);
        if (n >= 0) {
            return this.conditionStack[n];
        } else {
            return "INITIAL";
        }
    },

// alias for begin(condition)
pushState:function pushState(condition) {
        this.begin(condition);
    },

// return the number of states currently on the stack
stateStackSize:function stateStackSize() {
        return this.conditionStack.length;
    },
options: {},
performAction: function anonymous(yy,yy_,$avoiding_name_collisions,YY_START) {
var YYSTATE=YY_START;
switch($avoiding_name_collisions) {
case 0:return 13;
break;
case 1:return 14;
break;
case 2:return 16;
break;
case 3:return 17;
break;
case 4:return 18;
break;
case 5:return 19;
break;
case 6:return 8;
break;
case 7:return 6;
break;
case 8:return 10;
break;
case 9:return 11;
break;
case 10:return 4;
break;
case 11:return 5;
break;
case 12:return 21;
break;
case 13:;
break;
}
},
rules: [/^(?:-?[0-9]+(\.[0-9]+)?)/,/^(?:"[^"]+")/,/^(?:\$\([^\)]+\))/,/^(?:\$\|[^|]+\|)/,/^(?:\$\{[^\}]+\})/,/^(?:\$\[[^|]+\|-?[0-9]+(,-?[0-9]+)?\])/,/^(?:\+)/,/^(?:-)/,/^(?:\*)/,/^(?:\/)/,/^(?:\()/,/^(?:\))/,/^(?:$)/,/^(?:[ \t\n])/],
conditions: {"INITIAL":{"rules":[0,1,2,3,4,5,6,7,8,9,10,11,12,13],"inclusive":true}}
});
return lexer;
})();
parser.lexer = lexer;
function Parser () {
  this.yy = {};
}
Parser.prototype = parser;parser.Parser = Parser;
return new Parser;
})();


if (typeof require !== 'undefined' && typeof exports !== 'undefined') {
exports.parser = MathParser;
exports.Parser = MathParser.Parser;
exports.parse = function () { return MathParser.parse.apply(MathParser, arguments); };
exports.main = function commonjsMain(args) {
    if (!args[1]) {
        console.log('Usage: '+args[0]+' FILE');
        process.exit(1);
    }
    var source = require('fs').readFileSync(require('path').normalize(args[1]), "utf8");
    return exports.parser.parse(source);
};
if (typeof module !== 'undefined' && require.main === module) {
  exports.main(process.argv.slice(1));
}
};/***********************************************************************
 * collection.js: Run queries on Experience API data
 *
 * Initialize the ADL.Collection class with a list of xAPI statements,
 * then run SQL-style queries over the data, e.g. where, select, count.
 *
 * Comes in two versions: CollectionSync and CollectionAsync.
 ***********************************************************************/
"use strict";

// guarantee window.ADL, even in a worker
try {
	window.ADL = window.ADL || {};
}
catch(e){
	var window = {'ADL': {}};
}

// figure out script path if available
try {
	var workerScript = document.querySelector('script[src*="xapicollection"]').src;
}
catch(e){}

// poly-fill array checking
if(!Array.isArray){
	Array.isArray = function(obj){
		return obj.length >= 0 && !obj['length'];
	}
}

if(!String.prototype.reverse){
	String.prototype.reverse = function(){
		var ret = '';
		for(var i=this.length-1; i>=0; i--)
			ret += this.charAt(i);
		return ret;
	}
}

/*
 * Client scope
 */

(function(ADL){

	/*
	 * Retrieves some deep value at path from an object
	 */

	function parseXPath(path)
	{
		// break xpath into individual keys
		var parts;
		if(Array.isArray(path)){
			parts = path;
		}
		else
		{
			/*parts = path.split('.');
			for(var i=0; i<parts.length;){
				if(parts[i].slice(-1) === '\\')
					parts.splice(i, 2, parts[i].slice(0,-1)+'.'+parts[i+1]);
				else
					i++;
			}*/
			parts = [];

			// sanitize escaping (RtL for open brackets, LtR for close)
			var subpath = path
				.reverse()
				.replace('[[', '\x0E')
				.reverse()
				.replace(']]', '\x0F');

			while( subpath )
			{
				// pull the next part from the front of the path
				// if bracket, read to close bracket. if no bracket, read to dot or open bracket
				var match = /^(?:([^\[\.]+)|\[([^\]]+)\])\.?/.exec(subpath);
				//console.log(match);
				if( !match ){
					console.error('Invalid xpath:', path);
					return null;
				}
				else {
					var part = (match[1] || match[2] || '').replace('\x0E', '[').replace('\x0F', ']');
					parts.push( part );
					subpath = subpath.slice(match[0].length);
				}
			}
			//console.log(parts);
		}

		return parts;
	}

	function getVal(path,obj)
	{
		// if nothing to search, return null
		if(obj === undefined){
			return null;
		}

		// if no descent, just return object
		else if(path.length === 0){
			return obj;
		}

		else {
			var parts = parseXPath(path);
			
			// fetch deep path
			var scoped = parts[0], rest = parts.slice(1);
			if( scoped === '*' )
			{
				var ret = [], keys = [];

				if(Array.isArray(obj)){
					for(var i=0; i<obj.length; i++) keys.push(i);
				}
				else {
					keys = Object.keys(obj);
				}

				for(var i=0; i<keys.length; i++){
					var keyout = getVal(rest, obj[keys[i]]);
					if(Array.isArray(keyout))
						ret.push.apply(ret,keyout);
					else
						ret.push(keyout);
				}
				
				return ret;
			}
			else {
				return getVal(rest, obj[scoped]);
			}
		}
	}

	/*
	 * Set some deep value in an object
	 */
	function setVal(obj,path,value)
	{
		var parts = parseXPath(path);

		if(!obj){
			obj = {};
		}

		if(parts.length === 1){
			obj[parts[0]] = value;
		}
		else {
			if(obj[parts[0]] !== undefined)
				obj[parts[0]] = setVal(obj[parts[0]], parts.slice(1), value);
			else
				obj[parts[0]] = setVal({}, parts.slice(1), value);
		}

		return obj;
	}

	/*************************************************************
	 * CollectionSync - the core processor of statements
	 *
	 * This is where the magic happens. CollectionSync is initialized
	 * with an array of statements, processes those statements
	 * based on the method called, and returns a new CollectionSync
	 * object containing the results of the query.
	 *************************************************************/

	function CollectionSync(data){
		if(Array.isArray(data)){
			this.contents = data.slice();
		}
		else if(data instanceof CollectionSync){
			this.contents = data.contents.slice();
			this.parent = data;
		}
		else {
			this.contents = [];
		}
	}

	CollectionSync.prototype.exec = function(cb){
		cb(this.contents);
		return this.parent;
	}

	CollectionSync.prototype.save = function(){
		return new CollectionSync(this);
	}

	CollectionSync.prototype.append = function(data){
		this.contents = this.contents.concat(data);
		return this;
	}

	/*
	 * Generate a CSV based on the contents of the collection
	 * Returns a CSV string
	 */
	CollectionSync.prototype.toCSV = function()
	{
		function sanitize(str){
			if( typeof str === 'object' ) str = JSON.stringify(str);
			if( typeof str === 'string' ) str = str.replace(/"/g, '""');
			return '"' + str + '"';
		}

		if(this.contents.length > 0)
		{
			var ret = '';
			var headers = Object.keys(this.contents[0]);
			ret += headers.map(sanitize).join(',') + '\r\n';

			for(var i=0; i<this.contents.length; i++){
				ret += headers.map(function(h){
					return sanitize(this.contents[i][h]);
				}.bind(this))
				.join(',') + '\r\n';
			}
			return ret;
		}
		else {
			return '';
		}
	}



	/*
	 * Filter out data entries not matching the query expression
	 */
	CollectionSync.prototype.where = function(query)
	{
		/*
		 * Query format example
		 *   stmts.where('verb.id = passed or verb.id = failed and result.score.raw >= 50');
		 * 
		 * Query grammar:
		 *   value := parseInt | parseFloat | "(.*)" | /(.*)/i?
		 *   xpath := [A-Za-z0-9_]+(\.[A-za-z0-9_]+)*
		 *   cond := <xpath> (=|!=|>|<|>=|<=) <value>
		 *   andGrp := <expr> 'and' <expr> | <cond>
		 *   orGrp := <expr> 'or' <expr> | <andGrp>
		 *   expr := '(' <expr> ')' | <orGrp>
		 */

		var PARSE_ERROR = NaN;

		function parseWhere(str)
		{
			// expr := '(' <expr> ')' | <orGrp>
			function expr(str)
			{
				// check for parens
				var match = /^\s*\((.*)\)\s*$/.exec(str);
				if(match){
					return expr(match[1]);
				}
				else {
					return orGrp(str);
				}
			}
		
			// check if a string has the same number of left and right parens
			function matchedParens(str){
				var level = 0;
				for(var i=0; i<str.length; i++){
					if(str[i] === '('){
						level++;
					}
					else if(str[i] === ')'){
						level--;
					}
				}
				return level === 0;
			}
		
			// orGrp := <expr> 'or' <expr> | <andGrp>
			function orGrp(str)
			{
				// loop over each possible combo of or arguments
				var parts = str.split(/\bor\b/);
				var expr1 = '', expr2 = '';
				for(var i=1; i<parts.length; i++)
				{
					var tempexpr1 = parts.slice(0,i).join('or');
					var tempexpr2 = parts.slice(i).join('or');
		
					// if both args have matched parens, continue
					if( tempexpr1 != '' && matchedParens(tempexpr1)
						&& tempexpr2 != '' && matchedParens(tempexpr2)
					){
						expr1 = tempexpr1;
						expr2 = tempexpr2;
						break;
					}
				}
		
				// parse the two operands
				if( expr1 && expr2 )
				{
					var part1 = expr(expr1);
					var part2 = expr(expr2);
		
					if( part1 && part2 )
						return {or: [part1, part2]};
					else
						return PARSE_ERROR;
				}
				// or was not found, so try ands
				else {
					var ret = andGrp(str);
					if(ret) return ret;
					else return PARSE_ERROR;
				}
			}
		
			// andGrp := <expr> 'and' <expr> | <cond>
			function andGrp(str)
			{
				// loop over each possible combo of and arguments
				var parts = str.split(/\band\b/);
				var expr1 = '', expr2 = '';
				for(var i=1; i<parts.length; i++)
				{
					var tempexpr1 = parts.slice(0,i).join('and');
					var tempexpr2 = parts.slice(i).join('and');
		
					// if both args have matched parens, continue
					if( tempexpr1 != '' && matchedParens(tempexpr1)
						&& tempexpr2 != '' && matchedParens(tempexpr2)
					){
						expr1 = tempexpr1;
						expr2 = tempexpr2;
						break;
					}
				}
		
				// parse operands
				if( expr1 && expr2 )
				{
					var part1 = expr(expr1);
					var part2 = expr(expr2);
		
					if( part1 && part2 )
						return {and: [part1, part2]};
					else
						return PARSE_ERROR;
				}
				// no and found, try cond
				else {
					var ret = cond(str);
					if(ret) return ret;
					else return PARSE_ERROR;
				}
			}
		
			// cond := <xpath> (=|!=|>|<|>=|<=) <value>
			function cond(str)
			{
				// check for an operator
				var match = /^\s*(.*?)\s*(!=|>=|<=|=|>|<)\s*(.*)\s*$/.exec(str);
				if(match)
				{
					// parse operands
					var part1 = xpath(match[1]);
					var part2 = value(match[3]);
					if( part1 )
					{
						if( part2 instanceof RegExp ){
							if( match[2] === '=' )
								return {op:'re',xpath:part1,value:part2};
							else if( match[2] === '!=' )
								return {op:'nre',xpath:part1,value:part2};
							else {
								console.error('Regex comparison only supports = and !=');
								return PARSE_ERROR;
							}
		
						}
						else {
							// parse operator
							switch(match[2]){
								case  '=':  return {op: 'eq',xpath:part1,value:part2};
								case '!=':  return {op:'neq',xpath:part1,value:part2};
								case  '<':  return {op: 'lt',xpath:part1,value:part2};
								case '<=':  return {op:'leq',xpath:part1,value:part2};
								case  '>':  return {op: 'gt',xpath:part1,value:part2};
								case '>=':  return {op:'geq',xpath:part1,value:part2};
								default: return PARSE_ERROR;
							}
						}
					}
					// fail if operator or operand doesn't parse
					else return PARSE_ERROR;
				}
				else return PARSE_ERROR;
			}
		
			// xpath := [A-Za-z0-9_]+(\.[A-za-z0-9_]+)*
			function xpath(str){
				var match = /^\s*([^\.]+(?:\.[^\.]+)*)\s*$/.exec(str);
				if(match)
					return match[1];
				else return PARSE_ERROR;
			}
		
			// value := parseInt | parseFloat | "(.*)"
			function value(str){
				var val = null;
				str = str.trim();
				var isnan = Number.isNaN || isNaN;
				if( /^0[0-7]+$/.test(str) && !isnan(val = parseInt(str,8)) ){
					return val;
				}
				else if( /^\d+$/.test(str) && !isnan(val = parseInt(str,10)) ){
					return val;
				}
				else if( /^0x[0-9a-f]+$/i.test(str) && !isnan(val = parseInt(str,16)) ){
					return val;
				}
				else if(!isnan(val = parseFloat(str))){
					return val;
				}
				else if(val = /^\s*(["'])(.*)\1\s*$/.exec(str)){
					return val[2];
				}
				else if(val = /^\s*\/(.*)\/(i?)\s*$/.exec(str)){
					return new RegExp(val[1], val[2]);
				}
				else if(str === 'null'){
					return null;
				}
				else if(str === 'true' || str === 'false'){
					return str === 'true';
				}
				else return PARSE_ERROR;
			}
		
			var ret = expr(str);
			return ret != PARSE_ERROR ? ret : null;
		}
		
		/*
		 * Evaluate the parse tree generated by parseWhere
		 */

		function evalConditions(parse, stmt)
		{
			// check for missing logical operands
			if(Array.isArray(parse.and) && parse.and.length === 0){
				return true;
			}
			else if(Array.isArray(parse.or) && parse.or.length === 0){
				return false;
			}
		
			// check for conditions without wildcard, and if so evaluate
			else if(parse.op && !/\.\*\.?/.test(parse.xpath))
			{
				switch(parse.op){
					case 'eq': return getVal(parse.xpath,stmt) === parse.value;
					case 'neq': return getVal(parse.xpath,stmt) !== parse.value;
					case 'geq': return getVal(parse.xpath,stmt) >= parse.value;
					case 'leq': return getVal(parse.xpath,stmt) <= parse.value;
					case 'lt': return getVal(parse.xpath,stmt) < parse.value;
					case 'gt': return getVal(parse.xpath,stmt) > parse.value;
					case 're': return parse.value.test( getVal(parse.xpath,stmt) );
					case 'nre': return !parse.value.test( getVal(parse.xpath,stmt) );
					default: return false;
				}
			}
			// check for conditions with wildcard
			else if(parse.op && /\.\*\.?/.test(parse.xpath))
			{
				var values = getVal(parse.xpath,stmt);
				if(!values)
					return false;

				// loop over each returned value
				for(var i=0; i<values.length; i++)
				{
					var result;
					if(parse.op === 'eq')       result = values[i] === parse.value;
					else if(parse.op === 'neq') result = values[i] !== parse.value;
					else if(parse.op === 'geq') result = values[i] >= parse.value;
					else if(parse.op === 'leq') result = values[i] <= parse.value;
					else if(parse.op === 'lt')  result = values[i] < parse.value;
					else if(parse.op === 'gt')  result = values[i] > parse.value;
					else if(parse.op === 're')  result = parse.value.test( values[i] );
					else if(parse.op === 'nre') result = !parse.value.test( values[i] );
					else result = false;

					if(result)
						return true;
				}

				return false;
			}

			// check for and, and if so evaluate
			else if(parse.and)
			{
				// evaluate first operand
				if( !evalConditions(parse.and[0], stmt) )
					return false;
				// evaluate remaining operands
				else
					return evalConditions({and: parse.and.slice(1)}, stmt);
			}
			// check for or, and if so evaluate
			else if(parse.or)
			{
				// evaluate first operand
				if( evalConditions(parse.or[0], stmt) )
					return true;
				// evaluate remaining operands
				else
					return evalConditions({or: parse.or.slice(1)}, stmt);
			}

			// fail for any other structures. shouldn't happen
			else {
				return false;
			}
		}

		/*
		 * Execute the giant functions above
		 */

		// no-op if no query
		if( !query ) return this;
	
		// parse the query, abort filter if query didn't parse
		var parse = parseWhere(query);
		if( !parse ){
			console.error('Invalid where expression: '+query);
			return;
		}

		// for each entry in the dataset
		for(var i=0; i<this.contents.length; i++)
		{
			// remove from dataset if it doesn't match the conditions
			if( !evalConditions(parse, this.contents[i]) ){
				this.contents.splice(i--,1);
			}
		}
	
		// return the filtered data
		return this;
	}
	
	/*
	 * Perform numeric or string computations on the dataset
	 * and write the result to another field
	 */
	CollectionSync.prototype.math = function(dest, expr, level)
	{
		// check for recursive depth
		if(level && level > 0)
		{
			var data = this.contents;
			for(var i=0; i<data.length; i++){
				var subdata = new CollectionSync(data[i].data);
				subdata.math(dest, expr, level-1);
				data[i].data = subdata.contents;
			}
		}
		else
		{
			var ptree = MathParser.parse(expr);

			for(var i=0; i<this.contents.length; i++)
			{
				var data = this.contents[i];
				for(var path in ptree.xpaths){
					ptree.xpaths[path] = getVal(path, data);
				}

				try {
					setVal(data, dest, ptree.evaluate());
				}
				catch(e){
					console.log(e);
				}
			}
		}

		// return the computed data
		return this;
	}


	/*
	 * Pick out certain fields from each entry in the dataset
	 * syntax of selector := xpath ['as' alias] [',' xpath ['as' alias]]*
	 */
	CollectionSync.prototype.select = function(selector, level)
	{
		// check for recursive depth
		if(level && level > 0)
		{
			var data = this.contents;
			for(var i=0; i<data.length; i++){
				var subdata = new CollectionSync(data[i].data);
				subdata.select(selector, level-1);
				data[i].data = subdata.contents;
			}
		}
		else
		{
			// parse selector
	
			// for each field to be selected
			var cols = [];
			var xpaths = selector.split(',');
			// check for escaped commas
			for(var i=0; i<xpaths.length;){
				if(xpaths[i].slice(-1) === '\\')
					xpaths.splice(i, 2, xpaths[i].slice(0,-1)+','+xpaths[i+1]);
				else
					i++;
			}

			for( var i=0; i<xpaths.length; i++ )
			{
				// break into an xpath and an optional alias
				var parts = xpaths[i].split(' as ');
				cols.push({
					'xpath': parts[0].trim(),
					'alias': parts[1] ? parts[1].trim() : null
				});
			}
	
			// pick out selected fields
	
			// loop over entries in dataset
			var data = this.contents;
			var ret = [];
			for(var i=0; i<data.length; i++)
			{
				var row = {};
				// for each selection field
				for(var j=0; j<cols.length; j++){
					// save as old name, or alias if provided
					setVal(row, cols[j].alias || cols[j].xpath, getVal(cols[j].xpath, data[i]));
				}
				ret.push(row);
			}
	
			// return the selection
			this.contents = ret;
		}

		return this;
	}

	/*
	 * Form a relation between two fields in the data
	 */
	CollectionSync.prototype.relate = function(keypath, valuepath, level)
	{
		var data = this.contents;

		// check for recursion
		if( level && level > 0 )
		{
			// loop over datasets
			for(var i=0; i<data.length; i++){
				var subdata = new CollectionSync(data[i].data);
				subdata.relate(keypath, valuepath, level-1);
				data[i].data = subdata.contents;
			}
		}
		else
		{
			// loop over datasets
			for(var i=0; i<data.length; i++)
			{
				for(var j=0; j<data[i].data.length; j++){
					var key = getVal(keypath, data[i].data[j]);
					var val = getVal(valuepath, data[i].data[j]);
					data[i][key] = val;
				}
			}
		}

		return this;
	}

	/*
	 * Exactly what it sounds like
	 * Return some continuous subset of the data
	 */
	CollectionSync.prototype.slice = function(start,end)
	{
		if(end === null)
			end = undefined;
		this.contents = this.contents.slice(start,end);
		return this;
	}
	
	/*
	 * Sort dataset by given path
	 */
	CollectionSync.prototype.orderBy = function(path, direction)
	{
		var data = this.contents;

		// figure out ascending or descending
		if(direction === 'descending' || direction === 'desc')
			direction = -1;
		else
			direction = 1;

		data.sort(function(a,b){
			var aVal = getVal(path,a), bVal = getVal(path,b);

			// guarantee case insensitivity
			if(aVal.toLowerCase) aVal = aVal.toLowerCase();
			if(bVal.toLowerCase) bVal = bVal.toLowerCase();

			// any value is greater than null
			if(aVal!=null && bVal==null)
				return 1 * direction;
			else if(aVal==null && bVal!=null)
				return -1 * direction;

			// check equivalence
			else if(aVal == bVal)
				return 0;

			// all else fails, do a simple comparison
			else
				return (aVal<bVal ? -1 : 1) * direction;
		});

		return this;
	}

	/*
	 * Group with continuous values
	 */
	CollectionSync.prototype._groupByRange = function(path, range)
	{
		// validate range
		if( !(Array.isArray(range) && range.length === 3 && range[2]%1 === 0) )
			return this.groupBy(path);

		/*
		 * Generate range dividers
		 */

		// determine type of values
		var start = range[0], end = range[1], increment = range[2];
		var value, next;
		// values are date strings
		if( typeof(start) === 'string' && typeof(end) === 'string' && Date.parse(start) && Date.parse(end) ){
			value = function(x){
				return Date.parse(x);
			};
			next = function(x,i){
				var d = new Date(Date.parse(x)+i);
				return d.toISOString();
			};
		}
		// values are generic strings
		else if( typeof(start) === 'string' && typeof(end) === 'string' ){
			value = function(x){
				return x.charAt(0).toLowerCase().charCodeAt(0) - 'a'.charCodeAt(0);
			};
			next = function(x,i){
				return String.fromCharCode(x.charAt(0).toLowerCase().charCodeAt(0) + i);
			};
		}
		// all other types
		else {
			value = function(x){
				return x;
			};
			next = function(x,i){
				return x+i;
			};
		}

		// make sure bounds are reachable
		var bounds = [];
		if( (value(end)-value(start))*increment <= 0 ){
			console.error('Group range is open, cannot generate groups!');
			console.log(JSON.stringify(range));
			bounds = [start,end];
		}
		// flip bounds if end < start
		else if( value(start) > value(end) ){
			groupByRange(path, [end,start,-increment]);
			dataStack.push( dataStack.pop().reverse() );
			return;
		}
		else {
			// create boundary array
			for(var i=start; value(i)<value(end); i=next(i,increment)){
				bounds.push(i);
			}
			bounds.push(end);
		}

		/*
		 * Group by range
		 */

		// create groups by boundary
		var ret = [];
		for(var i=0; i<bounds.length-1; i++){
			ret.push({
				'group': bounds[i]+'-'+bounds[i+1],
				'groupStart': bounds[i],
				'groupEnd': bounds[i+1],
				'data': []
			});
		}

		// divide up data by group
		var data = this.contents;
		for(var i=0; i<data.length; i++)
		{
			var groupVal = value(getVal(path,data[i]));
			for(var j=0; j<ret.length; j++){
				if( value(ret[j].groupStart) <= groupVal && (
					groupVal < value(ret[j].groupEnd) || j==ret.length-1 && groupVal==value(ret[j].groupEnd)
				) )
					ret[j].data.push(data[i]);
			}
		}

		this.contents = ret;
		return this;
	}


	/*
	 * Group with discrete values
	 */
	CollectionSync.prototype.groupBy = function(path, range)
	{
		if(range)
			return this._groupByRange(path, range);

		var data = this.contents;

		// if data is already grouped, group the groups
		if( data[0] && data[0].group && data[0].data )
		{
			for(var i=0; i<data.length; i++)
			{
				var subgroup = new CollectionSync(data[i].data);
				subgroup.groupBy(path);
				data[i].data = subgroup.contents;
			}
		}
		else
		{
			// add each data entry to its respective group
			var groups = {};
			for(var i=0; i<data.length; i++)
			{
				var groupVal = getVal(path,data[i]);
	
				// if group field isn't found, 
				if( !groupVal ){
					continue;
				}
				// no group for found value, create one
				else if( !groups[groupVal] ){
					groups[groupVal] = [data[i]];
				}
				// add to existing group
				else {
					groups[groupVal].push(data[i]);
				}
			}
	
			// flatten groups
			var ret = [];
			for(var i in groups){
				ret.push({
					'group': i,
					'data': groups[i]
				});
			}
	
			this.contents = ret;
		}

		return this;
	}


	/*
	 * Take grouped data and return number of entries in each group
	 */
	CollectionSync.prototype.count = function(level)
	{
		var data = this.contents;

		// if the data isn't grouped, treat as one large group
		if(!data[0] || !data[0].group || !data[0].data){
			data = [{
				'group': 'all',
				'data': data
			}];
		}
		// if it's grouped and deep checking is requested, descend
		else if(level && level > 0){
			for(var i=0; i<data.length; i++){
				data[i].data = (new CollectionSync(data[i].data)).count(level-1).contents;
			}
			return this;
		}

		// loop over each group
		var ret = [];
		for(var i=0; i<data.length; i++)
		{
			// copy group id fields to new object
			var group = {};
			for(var j in data[i]){
				group[j] = data[i][j];
			}
			// add count and sample
			group.count = group.data.length;
			group.sample = group.data[0];
			ret.push(group);
		}
		
		this.contents = ret;
		return this;
	}

	/*
	 * Take grouped data and return total of values of entries in each group
	 */
	CollectionSync.prototype.sum = function(path,level)
	{
		if( !path )
			return this;

		var data = this.contents;

		// if the data isn't grouped, treat as one large group
		if(!data[0] || !data[0].group || !data[0].data){
			data = [{
				'group': 'all',
				'data': data
			}];
		}
		// if it's grouped and deep checking is requested, descend
		else if(level && level > 0){
			for(var i=0; i<data.length; i++){
				data[i].data = (new CollectionSync(data[i].data)).sum(path, level-1).contents;
			}
			return this;
		}


		// loop over each group
		var ret = [];
		for(var i=0; i<data.length; i++)
		{
			var sum = 0;
			for(var j=0; j<data[i].data.length; j++){
				sum += getVal(path, data[i].data[j]);
			}

			// copy group id fields to new object
			var group = {};
			for(var j in data[i]){
				group[j] = data[i][j];
			}
			// add sum and sample
			group.sum = sum;
			group.sample = group.data[0];
			ret.push(group);
		}

		this.contents = ret;
		return this;
	}

	/*
	 * Take grouped data and return average of values of entries in each group
	 */
	CollectionSync.prototype.average = function(path,level)
	{
		if( !path )
			return this;

		var data = this.contents;

		// if the data isn't grouped, treat as one large group
		if(!data[0] || !data[0].group || !data[0].data){
			data = [{
				'group': 'all',
				'data': data
			}];
		}
		// if it's grouped and deep checking is requested, descend
		else if(level && level > 0){
			for(var i=0; i<data.length; i++){
				data[i].data = (new CollectionSync(data[i].data)).average(path, level-1).contents;
			}
			return this;
		}


		// loop over each group
		var ret = [];
		for(var i=0; i<data.length; i++)
		{
			var sum = 0;
			for(var j=0; j<data[i].data.length; j++){
				sum += getVal(path, data[i].data[j]);
			}

			// copy group id fields to new object
			var group = {};
			for(var j in data[i]){
				group[j] = data[i][j];
			}
			// add average and sample
			group.average = group.data.length>0 ? sum/group.data.length : 0;
			group.sample = group.data[0];
			ret.push(group);
		}

		this.contents = ret;
		return this;
	}

	/*
	 * Take grouped data and return minimum of values of entries in each group
	 */
	CollectionSync.prototype.min = function(path,level)
	{
		if( !path ) return this;
		var data = this.contents;

		// if the data isn't grouped, treat as one large group
		var ret = [];
		if(!data[0] || !data[0].group || !data[0].data){
			data = [{
				'group': 'all',
				'data': data
			}];
		}
		// if it's grouped and deep checking is requested, descend
		else if(level && level > 0){
			for(var i=0; i<data.length; i++){
				data[i].data = (new CollectionSync(data[i].data)).min(path, level-1).contents;
			}
			return this;
		}


		// loop over each group
		for(var i=0; i<data.length; i++)
		{
			var min = Infinity;
			for(var j=0; j<data[i].data.length; j++){
				min = Math.min(min, getVal(path, data[i].data[j]));
			}

			// copy group id fields to new object
			var group = {};
			for(var j in data[i]){
				group[j] = data[i][j];
			}
			// add min and sample
			group.min = min === Infinity ? 0 : min;
			group.sample = group.data[0];
			ret.push(group);
		}

		this.contents = ret;
		return this;
	}

	/*
	 * Take grouped data and return maximum of values of entries in each group
	 */
	CollectionSync.prototype.max = function(path,level)
	{
		if( !path ) return this;
		var data = this.contents;

		// if the data isn't grouped, treat as one large group
		if(!data[0] || !data[0].group || !data[0].data){
			data = [{
				'group': 'all',
				'data': data
			}];
		}
		// if it's grouped and deep checking is requested, descend
		else if(level && level > 0){
			for(var i=0; i<data.length; i++){
				data[i].data = (new CollectionSync(data[i].data)).max(path, level-1).contents;
			}
			return this;
		}


		// loop over each group
		var ret = [];
		for(var i=0; i<data.length; i++)
		{
			var max = -Infinity;
			for(var j=0; j<data[i].data.length; j++){
				max = Math.max(max, getVal(path, data[i].data[j]));
			}

			// copy group id fields to new object
			var group = {};
			for(var j in data[i]){
				group[j] = data[i][j];
			}
			// add max and sample
			group.max = max === -Infinity ? 0 : max;
			group.sample = group.data[0];
			ret.push(group);
		}

		this.contents = ret;
		return this;
	}


	/*****************************************************************
	 * Collection class - asynchronous version of CollectionSync
	 *
	 * For any decently-sized dataset, CollectionSync will lock up the
	 * UI for an unnecessary amount of time. The CollectionAsync class
	 * exposes the same API, but wraps that functionality in a thread
	 * so the UI remains responsive.
	 *****************************************************************/


	function CollectionAsync(data)
	{
		this._callbacks = {};

		if( !window.Worker ){
			throw new Error('Your browser does not support WebWorkers, and cannot use the CollectionAsync class. Use CollectionSync instead.');
		}

		this._worker = new Worker(workerScript);
		this._worker.onmessage = function(evt)
		{
			var data = CollectionAsync.deserialize(evt.data);
			if( this._callbacks[data[0]] ){
				this._callbacks[data[0]](data[1]);
				delete this._callbacks[data[0]];
			}
		}.bind(this);

		var payload = CollectionAsync.serialize(['push',data]);
		try {
			this._worker.postMessage(payload, [payload]);
		}
		catch(e){
			this._worker.postMessage(payload);
		}

		if( payload.byteLength > 0 ){
			console.log('Warning: Your browser does not support WebWorker transfers. Performance of this site may suffer as a result.');
		}
	}

	CollectionAsync.serialize = function(obj)
	{
		var json = JSON.stringify(obj);
		var buf = new ArrayBuffer(2*json.length);
		var view = new Uint16Array(buf);
		for(var offset=0; offset<json.length; offset++){
			view[offset] = json.charCodeAt(offset);
		}
		return buf;
	};

	CollectionAsync.deserialize = function(buffer)
	{
		var json = '';
		var intBuffer = new Uint16Array(buffer);
		for(var i=0; i<intBuffer.length; i+=1000)
			json += String.fromCharCode.apply(null, intBuffer.subarray(i,i+1000));
		return JSON.parse(json);
	}

	CollectionAsync.prototype.exec = function(cb)
	{
		// generate random callback id, check for duplicates
		var id;
		while( this._callbacks[id = Math.floor( Math.random() * 65536 )] );

		this._callbacks[id] = cb;
		this._worker.postMessage(CollectionAsync.serialize(['exec', id]));
		return this;
	}

	CollectionAsync.prototype.append = function(data)
	{
		var payload = CollectionAsync.serialize(['append',data]);
		try {
			this._worker.postMessage(payload, [payload]);
		}
		catch(e){
			this._worker.postMessage(payload);
		}

		return this;
	}

	function proxyFactory(name){
		return function(){
			var args = Array.prototype.slice.call(arguments);
			this._worker.postMessage(CollectionAsync.serialize([name].concat(args)));
			return this;
		}
	}

	CollectionAsync.prototype.save    = proxyFactory('save');
	CollectionAsync.prototype.where   = proxyFactory('where');
	CollectionAsync.prototype.math    = proxyFactory('math');
	CollectionAsync.prototype.select  = proxyFactory('select');
	CollectionAsync.prototype.relate  = proxyFactory('relate');
	CollectionAsync.prototype.slice   = proxyFactory('slice');
	CollectionAsync.prototype.orderBy = proxyFactory('orderBy');
	CollectionAsync.prototype.groupBy = proxyFactory('groupBy');
	CollectionAsync.prototype.count   = proxyFactory('count');
	CollectionAsync.prototype.sum     = proxyFactory('sum');
	CollectionAsync.prototype.average = proxyFactory('average');
	CollectionAsync.prototype.min     = proxyFactory('min');
	CollectionAsync.prototype.max     = proxyFactory('max');

	ADL.CollectionSync = CollectionSync;
	ADL.CollectionAsync = CollectionAsync;
	ADL.Collection = CollectionSync;

}(window.ADL));


/*
 * Thread-specific scope
 */
(function(CollectionAsync, CollectionSync){

	var db = null;

	try {
		onmessage = function(evt)
		{
			var data = CollectionAsync.deserialize(evt.data);

			if( data[0] === 'exec' )
			{
				var cbHandle = data[1];
				if(db){
					db = db.exec(function(data){
						var payload = CollectionAsync.serialize([cbHandle, data]);
						try {
							postMessage(payload, [payload]);
						}
						catch(e){
							postMessage(payload);
						}
					});
				}
				else {
					postMessage(CollectionAsync.serialize([cbHandle, 'error','nodata']));
				}
			}
			else if( data[0] === 'push' ){
				var newdb = new CollectionSync(data[1], db);
				db = newdb;
			}
			else {
				// execute the function at [0] with [1-n] as args
				db = db[data[0]].apply(db, data.slice(1));
			}
		};
	}
	catch(e){
		if( e.message !== 'onmessage is not defined' ){
			throw e;
		}
	}

}(window.ADL.CollectionAsync, window.ADL.CollectionSync));


/*
 * Node.js export code
 */
try {
	exports.CollectionSync = window.ADL.CollectionSync;
}
catch(e){
	if( ! /'?exports'? is (?:not |un)defined/.test(e.message) )
		throw e;
}

